local Telestone = Class(function(self, inst)
self.inst = inst
self.locations = { }
self.marked = false
self.markedcave = false
self.onMark = nil
self.onRecall = nil
self.onReset = nil
self.season = nil
end)

function Telestone:OnSave()
    local data = {}
				data.marked = self.marked
				data.varxs = self.locations.currentsurlocation["x"] 
				data.varys = self.locations.currentsurlocation["y"] 
				data.varzs = self.locations.currentsurlocation["z"]
				data.markedcave = self.markedcave
				data.varxc = self.locations.currentcavlocation["x"] 
				data.varyc = self.locations.currentcavlocation["y"] 
				data.varzc = self.locations.currentcavlocation["z"]
    return data
end

function Telestone:OnLoad(data)
    self.season = GetSeasonManager():GetSeason()
	if data then 
		self.marked = data.marked
		self.locations.currentsurlocation = { }
		self.locations.currentsurlocation["x"] = data.varxs
		self.locations.currentsurlocation["y"] = data.varys
		self.locations.currentsurlocation["z"] = data.varzs
		self.markedcave = data.markedcave
		self.locations.currentcavlocation = { }
		self.locations.currentcavlocation["x"] = data.varxc
		self.locations.currentcavlocation["y"] = data.varyc
		self.locations.currentcavlocation["z"] = data.varzc
	end
end

function Telestone:CollectInventoryActions(doer, actions)
  if self:CanInteract() then
       if (self:IsMarked() or self:IsMarkedCave()) and TheInput:IsKeyDown(KEY_CTRL) then
	        table.insert(actions, ACTIONS.RESET)
       elseif (self:IsMarked() and self.season ~= "caves") or (self:IsMarkedCave() and self.season == "caves") then
	        table.insert(actions, ACTIONS.RECALL)		
	   else
		    table.insert(actions, ACTIONS.MARK)
	   end		
   end
end

function Telestone:Mark(inst, doer)

	if self.onMark then
		self.onMark(self.inst, doer)
	end

self.season = GetSeasonManager():GetSeason()
    if self.season ~= "caves" then
       self.locations.currentsurlocation = Point(GetPlayer().Transform:GetWorldPosition())
       self.marked = true
    elseif self.season == "caves" then
       self.locations.currentcavlocation = Point(GetPlayer().Transform:GetWorldPosition())
       self.markedcave = true
    end
end

function Telestone:Reset(inst, doer)

	if self.onReset then
		self.onReset(self.inst, doer)
	end

self.season = GetSeasonManager():GetSeason()
   if self.season ~= "caves" and self:IsMarked() then
      self.locationsur = nil
      self.marked = false
   elseif self.season == "caves" and self:IsMarkedCave() then
          self.locationcav = nil
          self.markedcave = false
   end
end

function Telestone:CanInteract()
	if self.caninteractfn then
		return self.caninteractfn(self.inst)
	else
		return true
	end
end

function Telestone:Recall(doer)
	if self.onRecall then 
		self.onRecall(self.inst, doer)
	end
	
	self:Teleport(doer)
	
	if doer.components.leader then
		for follower,v in pairs(doer.components.leader.followers) do
			self:Teleport(follower)
		end
	end

	if doer.components.inventory then
		for k,item in pairs(doer.components.inventory.itemslots) do
			if item.components.leader then
				for follower,v in pairs(item.components.leader.followers) do
					self:Teleport(follower)
				end
			end
		end
		
		for k,equipped in pairs(doer.components.inventory.equipslots) do
			if equipped and equipped.components.container then
				local container = equipped.components.container
				for j,item in pairs(container.slots) do
					if item.components.leader then
						for follower,v in pairs(item.components.leader.followers) do
							self:Teleport(follower)
						end
					end
				end
			end
		end
	end

	   if self.season ~= "caves" and self:IsMarked() then
	   self.marked = false
	   elseif self.season == "caves" and self:IsMarkedCave() then
	   self.markedcave = false
	   end
end

function Telestone:Teleport(obj)

    local offset = 2.0
    local angle = math.random()*360
	
    if (self.season ~= "caves" and self.marked == true) then
 
		self.locations.currentsurlocation.x = self.locations.currentsurlocation.x + math.sin(angle)*offset
		self.locations.currentsurlocation.z = self.locations.currentsurlocation.z + math.cos(angle)*offset
		if obj.Physics then
			obj.Physics:Teleport(self.locations.currentsurlocation.x, self.locations.currentsurlocation.y, self.locations.currentsurlocation.z)
		elseif obj.Transform then
			obj.Transform:SetPosition(self.locations.currentsurlocation.x, self.locations.currentsurlocation.y, self.locations.currentsurlocation.z)
			
		end	
	end
	
	if (self.season == "caves" and self.markedcave == true) then

		self.locations.currentcavlocation.x = self.locations.currentcavlocation.x + math.sin(angle)*offset
		self.locations.currentcavlocation.z = self.locations.currentcavlocation.z + math.cos(angle)*offset
		if obj.Physics then
			obj.Physics:Teleport(self.locations.currentcavlocation.x, self.locations.currentcavlocation.y, self.locations.currentcavlocation.z)
		elseif obj.Transform then
			obj.Transform:SetPosition(self.locations.currentcavlocation.x, self.locations.currentcavlocation.y, self.locations.currentcavlocation.z)
			
		end
    end
end

function Telestone:IsMarkedCave()
    return self.markedcave
end

function Telestone:IsMarked()
	return self.marked
end

return Telestone